package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.MetricsId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricsConfiguration(
    id: MetricsId,
    filter: Option[io.github.vigoo.zioaws.s3.model.MetricsFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsConfiguration = {
    import MetricsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsConfiguration
      .builder()
      .id(id: java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.MetricsConfiguration.wrap(buildAwsValue())
}
object MetricsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.MetricsConfiguration =
      io.github.vigoo.zioaws.s3.model
        .MetricsConfiguration(idValue, filterValue.map(value => value.editable))
    def idValue: MetricsId
    def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly]
    def id: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(idValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly {
    override def idValue: MetricsId = impl.id(): MetricsId
    override def filterValue
        : Option[io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly] = scala
      .Option(impl.filter())
      .map(value => io.github.vigoo.zioaws.s3.model.MetricsFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsConfiguration
  ): io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly =
    new Wrapper(impl)
}
