package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccessPointArn, Prefix}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MetricsFilter(
    prefix: Option[Prefix] = None,
    tag: Option[io.github.vigoo.zioaws.s3.model.Tag] = None,
    accessPointArn: Option[AccessPointArn] = None,
    and: Option[io.github.vigoo.zioaws.s3.model.MetricsAndOperator] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MetricsFilter = {
    import MetricsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MetricsFilter
      .builder()
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .optionallyWith(tag.map(value => value.buildAwsValue()))(_.tag)
      .optionallyWith(accessPointArn.map(value => value: java.lang.String))(
        _.accessPointArn
      )
      .optionallyWith(and.map(value => value.buildAwsValue()))(_.and)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.MetricsFilter.wrap(buildAwsValue())
}
object MetricsFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.MetricsFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.MetricsFilter =
      io.github.vigoo.zioaws.s3.model.MetricsFilter(
        prefixValue.map(value => value),
        tagValue.map(value => value.editable),
        accessPointArnValue.map(value => value),
        andValue.map(value => value.editable)
      )
    def prefixValue: Option[Prefix]
    def tagValue: Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly]
    def accessPointArnValue: Option[AccessPointArn]
    def andValue
        : Option[io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly]
    def prefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefixValue)
    def tag: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] =
      AwsError.unwrapOptionField("tag", tagValue)
    def accessPointArn: ZIO[Any, AwsError, AccessPointArn] =
      AwsError.unwrapOptionField("accessPointArn", accessPointArnValue)
    def and: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly
    ] = AwsError.unwrapOptionField("and", andValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ) extends io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly {
    override def prefixValue: Option[Prefix] =
      scala.Option(impl.prefix()).map(value => value: Prefix)
    override def tagValue
        : Option[io.github.vigoo.zioaws.s3.model.Tag.ReadOnly] = scala
      .Option(impl.tag())
      .map(value => io.github.vigoo.zioaws.s3.model.Tag.wrap(value))
    override def accessPointArnValue: Option[AccessPointArn] =
      scala.Option(impl.accessPointArn()).map(value => value: AccessPointArn)
    override def andValue
        : Option[io.github.vigoo.zioaws.s3.model.MetricsAndOperator.ReadOnly] =
      scala
        .Option(impl.and())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.MetricsAndOperator.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MetricsFilter
  ): io.github.vigoo.zioaws.s3.model.MetricsFilter.ReadOnly = new Wrapper(impl)
}
