package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  Initiated,
  ObjectKey,
  MultipartUploadId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class MultipartUpload(
    uploadId: Option[MultipartUploadId] = None,
    key: Option[ObjectKey] = None,
    initiated: Option[Initiated] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None,
    initiator: Option[io.github.vigoo.zioaws.s3.model.Initiator] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.MultipartUpload = {
    import MultipartUpload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.MultipartUpload
      .builder()
      .optionallyWith(uploadId.map(value => value: java.lang.String))(
        _.uploadId
      )
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(initiated.map(value => value: Instant))(_.initiated)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly =
    io.github.vigoo.zioaws.s3.model.MultipartUpload.wrap(buildAwsValue())
}
object MultipartUpload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.MultipartUpload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.MultipartUpload =
      io.github.vigoo.zioaws.s3.model.MultipartUpload(
        uploadIdValue.map(value => value),
        keyValue.map(value => value),
        initiatedValue.map(value => value),
        storageClassValue.map(value => value),
        ownerValue.map(value => value.editable),
        initiatorValue.map(value => value.editable),
        checksumAlgorithmValue.map(value => value)
      )
    def uploadIdValue: Option[MultipartUploadId]
    def keyValue: Option[ObjectKey]
    def initiatedValue: Option[Initiated]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def initiatorValue
        : Option[io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def uploadId: ZIO[Any, AwsError, MultipartUploadId] =
      AwsError.unwrapOptionField("uploadId", uploadIdValue)
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def initiated: ZIO[Any, AwsError, Initiated] =
      AwsError.unwrapOptionField("initiated", initiatedValue)
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
    def initiator: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly
    ] = AwsError.unwrapOptionField("initiator", initiatorValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ) extends io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly {
    override def uploadIdValue: Option[MultipartUploadId] =
      scala.Option(impl.uploadId()).map(value => value: MultipartUploadId)
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def initiatedValue: Option[Initiated] =
      scala.Option(impl.initiated()).map(value => value: Initiated)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
    override def initiatorValue
        : Option[io.github.vigoo.zioaws.s3.model.Initiator.ReadOnly] = scala
      .Option(impl.initiator())
      .map(value => io.github.vigoo.zioaws.s3.model.Initiator.wrap(value))
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.MultipartUpload
  ): io.github.vigoo.zioaws.s3.model.MultipartUpload.ReadOnly = new Wrapper(
    impl
  )
}
