package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{VersionCount, Days}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionExpiration(
    noncurrentDays: Option[Days] = None,
    newerNoncurrentVersions: Option[VersionCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration = {
    import NoncurrentVersionExpiration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
      .builder()
      .optionallyWith(noncurrentDays.map(value => value: Integer))(
        _.noncurrentDays
      )
      .optionallyWith(newerNoncurrentVersions.map(value => value: Integer))(
        _.newerNoncurrentVersions
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration
      .wrap(buildAwsValue())
}
object NoncurrentVersionExpiration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration =
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration(
        noncurrentDaysValue.map(value => value),
        newerNoncurrentVersionsValue.map(value => value)
      )
    def noncurrentDaysValue: Option[Days]
    def newerNoncurrentVersionsValue: Option[VersionCount]
    def noncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDaysValue)
    def newerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] =
      AwsError.unwrapOptionField(
        "newerNoncurrentVersions",
        newerNoncurrentVersionsValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ) extends io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly {
    override def noncurrentDaysValue: Option[Days] =
      scala.Option(impl.noncurrentDays()).map(value => value: Days)
    override def newerNoncurrentVersionsValue: Option[VersionCount] = scala
      .Option(impl.newerNoncurrentVersions())
      .map(value => value: VersionCount)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration
  ): io.github.vigoo.zioaws.s3.model.NoncurrentVersionExpiration.ReadOnly =
    new Wrapper(impl)
}
