package io.github.vigoo.zioaws.s3.model
import java.lang.Integer
import io.github.vigoo.zioaws.s3.model.primitives.{VersionCount, Days}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NoncurrentVersionTransition(
    noncurrentDays: Option[Days] = None,
    storageClass: Option[
      io.github.vigoo.zioaws.s3.model.TransitionStorageClass
    ] = None,
    newerNoncurrentVersions: Option[VersionCount] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition = {
    import NoncurrentVersionTransition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
      .builder()
      .optionallyWith(noncurrentDays.map(value => value: Integer))(
        _.noncurrentDays
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(newerNoncurrentVersions.map(value => value: Integer))(
        _.newerNoncurrentVersions
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly =
    io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition
      .wrap(buildAwsValue())
}
object NoncurrentVersionTransition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition =
      io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition(
        noncurrentDaysValue.map(value => value),
        storageClassValue.map(value => value),
        newerNoncurrentVersionsValue.map(value => value)
      )
    def noncurrentDaysValue: Option[Days]
    def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.TransitionStorageClass]
    def newerNoncurrentVersionsValue: Option[VersionCount]
    def noncurrentDays: ZIO[Any, AwsError, Days] =
      AwsError.unwrapOptionField("noncurrentDays", noncurrentDaysValue)
    def storageClass: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.TransitionStorageClass
    ] = AwsError.unwrapOptionField("storageClass", storageClassValue)
    def newerNoncurrentVersions: ZIO[Any, AwsError, VersionCount] =
      AwsError.unwrapOptionField(
        "newerNoncurrentVersions",
        newerNoncurrentVersionsValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ) extends io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly {
    override def noncurrentDaysValue: Option[Days] =
      scala.Option(impl.noncurrentDays()).map(value => value: Days)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.TransitionStorageClass] = scala
      .Option(impl.storageClass())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.TransitionStorageClass.wrap(value)
      )
    override def newerNoncurrentVersionsValue: Option[VersionCount] = scala
      .Option(impl.newerNoncurrentVersions())
      .map(value => value: VersionCount)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition
  ): io.github.vigoo.zioaws.s3.model.NoncurrentVersionTransition.ReadOnly =
    new Wrapper(impl)
}
