package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotificationConfiguration(
    topicConfigurations: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.TopicConfiguration]
    ] = None,
    queueConfigurations: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.QueueConfiguration]
    ] = None,
    lambdaFunctionConfigurations: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration]
    ] = None,
    eventBridgeConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.EventBridgeConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NotificationConfiguration = {
    import NotificationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NotificationConfiguration
      .builder()
      .optionallyWith(
        topicConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.topicConfigurations)
      .optionallyWith(
        queueConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.queueConfigurations)
      .optionallyWith(
        lambdaFunctionConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lambdaFunctionConfigurations)
      .optionallyWith(
        eventBridgeConfiguration.map(value => value.buildAwsValue())
      )(_.eventBridgeConfiguration)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.NotificationConfiguration
      .wrap(buildAwsValue())
}
object NotificationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.NotificationConfiguration =
      io.github.vigoo.zioaws.s3.model.NotificationConfiguration(
        topicConfigurationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        queueConfigurationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        lambdaFunctionConfigurationsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        eventBridgeConfigurationValue.map(value => value.editable)
      )
    def topicConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly]
    ]
    def queueConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly]
    ]
    def lambdaFunctionConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly]
    ]
    def eventBridgeConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.EventBridgeConfiguration.ReadOnly
    ]
    def topicConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "topicConfigurations",
      topicConfigurationsValue
    )
    def queueConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "queueConfigurations",
      queueConfigurationsValue
    )
    def lambdaFunctionConfigurations: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lambdaFunctionConfigurations",
      lambdaFunctionConfigurationsValue
    )
    def eventBridgeConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.EventBridgeConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "eventBridgeConfiguration",
      eventBridgeConfigurationValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly {
    override def topicConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.TopicConfiguration.ReadOnly]
    ] = scala
      .Option(impl.topicConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.TopicConfiguration.wrap(item)
        }.toList
      )
    override def queueConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly]
    ] = scala
      .Option(impl.queueConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.QueueConfiguration.wrap(item)
        }.toList
      )
    override def lambdaFunctionConfigurationsValue: Option[
      List[io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.ReadOnly]
    ] = scala
      .Option(impl.lambdaFunctionConfigurations())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.s3.model.LambdaFunctionConfiguration.wrap(item)
        }.toList
      )
    override def eventBridgeConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.EventBridgeConfiguration.ReadOnly
    ] = scala
      .Option(impl.eventBridgeConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.EventBridgeConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfiguration
  ): io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly =
    new Wrapper(impl)
}
