package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NotificationConfigurationFilter(
    key: Option[io.github.vigoo.zioaws.s3.model.S3KeyFilter] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter = {
    import NotificationConfigurationFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
      .builder()
      .optionallyWith(key.map(value => value.buildAwsValue()))(_.key)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly =
    io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
      .wrap(buildAwsValue())
}
object NotificationConfigurationFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter =
      io.github.vigoo.zioaws.s3.model
        .NotificationConfigurationFilter(keyValue.map(value => value.editable))
    def keyValue: Option[io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly]
    def key: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly
    ] = AwsError.unwrapOptionField("key", keyValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ) extends io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly {
    override def keyValue
        : Option[io.github.vigoo.zioaws.s3.model.S3KeyFilter.ReadOnly] = scala
      .Option(impl.key())
      .map(value => io.github.vigoo.zioaws.s3.model.S3KeyFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.NotificationConfigurationFilter
  ): io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly =
    new Wrapper(impl)
}
