package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectCannedACL {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectCannedACL
}
object ObjectCannedACL {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectCannedACL
  ): io.github.vigoo.zioaws.s3.model.ObjectCannedACL = value match {
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.PRIVATE =>
      val r = `private`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.PUBLIC_READ =>
      val r = `public-read`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.PUBLIC_READ_WRITE =>
      val r = `public-read-write`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.AUTHENTICATED_READ =>
      val r = `authenticated-read`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.AWS_EXEC_READ =>
      val r = `aws-exec-read`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.BUCKET_OWNER_READ =>
      val r = `bucket-owner-read`
      r
    case software.amazon.awssdk.services.s3.model.ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL =>
      val r = `bucket-owner-full-control`
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.UNKNOWN_TO_SDK_VERSION
  }
  case object `private`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.PRIVATE
  }
  case object `public-read`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.PUBLIC_READ
  }
  case object `public-read-write`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.PUBLIC_READ_WRITE
  }
  case object `authenticated-read`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.AUTHENTICATED_READ
  }
  case object `aws-exec-read`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.AWS_EXEC_READ
  }
  case object `bucket-owner-read`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.BUCKET_OWNER_READ
  }
  case object `bucket-owner-full-control`
      extends io.github.vigoo.zioaws.s3.model.ObjectCannedACL {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectCannedACL =
      software.amazon.awssdk.services.s3.model.ObjectCannedACL.BUCKET_OWNER_FULL_CONTROL
  }
}
