package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{ObjectVersionId, ObjectKey}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectIdentifier(
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectIdentifier = {
    import ObjectIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectIdentifier
      .builder()
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectIdentifier.wrap(buildAwsValue())
}
object ObjectIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectIdentifier =
      io.github.vigoo.zioaws.s3.model
        .ObjectIdentifier(keyValue, versionIdValue.map(value => value))
    def keyValue: ObjectKey
    def versionIdValue: Option[ObjectVersionId]
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ) extends io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly {
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectIdentifier
  ): io.github.vigoo.zioaws.s3.model.ObjectIdentifier.ReadOnly = new Wrapper(
    impl
  )
}
