package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectLockConfiguration(
    objectLockEnabled: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockEnabled
    ] = None,
    rule: Option[io.github.vigoo.zioaws.s3.model.ObjectLockRule] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockConfiguration = {
    import ObjectLockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
      .builder()
      .optionallyWith(objectLockEnabled.map(value => value.unwrap))(
        _.objectLockEnabled
      )
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration
      .wrap(buildAwsValue())
}
object ObjectLockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration =
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration(
        objectLockEnabledValue.map(value => value),
        ruleValue.map(value => value.editable)
      )
    def objectLockEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockEnabled]
    def ruleValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly]
    def objectLockEnabled: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockEnabled
    ] = AwsError.unwrapOptionField("objectLockEnabled", objectLockEnabledValue)
    def rule: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly
    ] = AwsError.unwrapOptionField("rule", ruleValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly {
    override def objectLockEnabledValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockEnabled] = scala
      .Option(impl.objectLockEnabled())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ObjectLockEnabled.wrap(value)
      )
    override def ruleValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly] =
      scala
        .Option(impl.rule())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockRule.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockConfiguration
  ): io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly =
    new Wrapper(impl)
}
