package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait ObjectLockEnabled {
  def unwrap: software.amazon.awssdk.services.s3.model.ObjectLockEnabled
}
object ObjectLockEnabled {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.ObjectLockEnabled
  ): io.github.vigoo.zioaws.s3.model.ObjectLockEnabled = value match {
    case software.amazon.awssdk.services.s3.model.ObjectLockEnabled.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.ObjectLockEnabled.ENABLED =>
      val r = Enabled
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.ObjectLockEnabled {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockEnabled =
      software.amazon.awssdk.services.s3.model.ObjectLockEnabled.UNKNOWN_TO_SDK_VERSION
  }
  case object Enabled
      extends io.github.vigoo.zioaws.s3.model.ObjectLockEnabled {
    override def unwrap
        : software.amazon.awssdk.services.s3.model.ObjectLockEnabled =
      software.amazon.awssdk.services.s3.model.ObjectLockEnabled.ENABLED
  }
}
