package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectLockLegalHold(
    status: Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockLegalHold = {
    import ObjectLockLegalHold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.wrap(buildAwsValue())
}
object ObjectLockLegalHold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold =
      io.github.vigoo.zioaws.s3.model
        .ObjectLockLegalHold(statusValue.map(value => value))
    def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus]
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ) extends io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly {
    override def statusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockLegalHold
  ): io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly = new Wrapper(
    impl
  )
}
