package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Date
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectLockRetention(
    mode: Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode] =
      None,
    retainUntilDate: Option[Date] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockRetention = {
    import ObjectLockRetention.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockRetention
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(retainUntilDate.map(value => value: Instant))(
        _.retainUntilDate
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectLockRetention.wrap(buildAwsValue())
}
object ObjectLockRetention {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectLockRetention =
      io.github.vigoo.zioaws.s3.model.ObjectLockRetention(
        modeValue.map(value => value),
        retainUntilDateValue.map(value => value)
      )
    def modeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode]
    def retainUntilDateValue: Option[Date]
    def mode: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode
    ] = AwsError.unwrapOptionField("mode", modeValue)
    def retainUntilDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("retainUntilDate", retainUntilDateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ) extends io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly {
    override def modeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode] =
      scala
        .Option(impl.mode())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockRetentionMode.wrap(value)
        )
    override def retainUntilDateValue: Option[Date] =
      scala.Option(impl.retainUntilDate()).map(value => value: Date)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRetention
  ): io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly = new Wrapper(
    impl
  )
}
