package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectLockRule(
    defaultRetention: Option[io.github.vigoo.zioaws.s3.model.DefaultRetention] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectLockRule = {
    import ObjectLockRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectLockRule
      .builder()
      .optionallyWith(defaultRetention.map(value => value.buildAwsValue()))(
        _.defaultRetention
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectLockRule.wrap(buildAwsValue())
}
object ObjectLockRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectLockRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectLockRule =
      io.github.vigoo.zioaws.s3.model
        .ObjectLockRule(defaultRetentionValue.map(value => value.editable))
    def defaultRetentionValue
        : Option[io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly]
    def defaultRetention: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly
    ] = AwsError.unwrapOptionField("defaultRetention", defaultRetentionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRule
  ) extends io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly {
    override def defaultRetentionValue
        : Option[io.github.vigoo.zioaws.s3.model.DefaultRetention.ReadOnly] =
      scala
        .Option(impl.defaultRetention())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.DefaultRetention.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectLockRule
  ): io.github.vigoo.zioaws.s3.model.ObjectLockRule.ReadOnly = new Wrapper(impl)
}
