package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ETag,
  IsLatest,
  LastModified,
  ObjectKey,
  ObjectVersionId
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ObjectVersion(
    eTag: Option[ETag] = None,
    checksumAlgorithm: Option[
      Iterable[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    ] = None,
    size: Option[Long] = None,
    storageClass: Option[
      io.github.vigoo.zioaws.s3.model.ObjectVersionStorageClass
    ] = None,
    key: Option[ObjectKey] = None,
    versionId: Option[ObjectVersionId] = None,
    isLatest: Option[IsLatest] = None,
    lastModified: Option[LastModified] = None,
    owner: Option[io.github.vigoo.zioaws.s3.model.Owner] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ObjectVersion = {
    import ObjectVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ObjectVersion
      .builder()
      .optionallyWith(eTag.map(value => value: java.lang.String))(_.eTag)
      .optionallyWith(
        checksumAlgorithm.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.checksumAlgorithmWithStrings)
      .optionallyWith(size.map(value => value: java.lang.Long))(_.size)
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(key.map(value => value: java.lang.String))(_.key)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(isLatest.map(value => value: java.lang.Boolean))(
        _.isLatest
      )
      .optionallyWith(lastModified.map(value => value: Instant))(_.lastModified)
      .optionallyWith(owner.map(value => value.buildAwsValue()))(_.owner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ObjectVersion.wrap(buildAwsValue())
}
object ObjectVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.ObjectVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ObjectVersion =
      io.github.vigoo.zioaws.s3.model.ObjectVersion(
        eTagValue.map(value => value),
        checksumAlgorithmValue.map(value => value),
        sizeValue.map(value => value),
        storageClassValue.map(value => value),
        keyValue.map(value => value),
        versionIdValue.map(value => value),
        isLatestValue.map(value => value),
        lastModifiedValue.map(value => value),
        ownerValue.map(value => value.editable)
      )
    def eTagValue: Option[ETag]
    def checksumAlgorithmValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]]
    def sizeValue: Option[Long]
    def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectVersionStorageClass]
    def keyValue: Option[ObjectKey]
    def versionIdValue: Option[ObjectVersionId]
    def isLatestValue: Option[IsLatest]
    def lastModifiedValue: Option[LastModified]
    def ownerValue: Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly]
    def eTag: ZIO[Any, AwsError, ETag] =
      AwsError.unwrapOptionField("eTag", eTagValue)
    def checksumAlgorithm: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ]] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def size: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("size", sizeValue)
    def storageClass: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectVersionStorageClass
    ] = AwsError.unwrapOptionField("storageClass", storageClassValue)
    def key: ZIO[Any, AwsError, ObjectKey] =
      AwsError.unwrapOptionField("key", keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def isLatest: ZIO[Any, AwsError, IsLatest] =
      AwsError.unwrapOptionField("isLatest", isLatestValue)
    def lastModified: ZIO[Any, AwsError, LastModified] =
      AwsError.unwrapOptionField("lastModified", lastModifiedValue)
    def owner
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] =
      AwsError.unwrapOptionField("owner", ownerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ) extends io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly {
    override def eTagValue: Option[ETag] =
      scala.Option(impl.eTag()).map(value => value: ETag)
    override def checksumAlgorithmValue
        : Option[List[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]] =
      scala
        .Option(impl.checksumAlgorithm())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(item)
          }.toList
        )
    override def sizeValue: Option[Long] =
      scala.Option(impl.size()).map(value => value: Long)
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectVersionStorageClass] =
      scala
        .Option(impl.storageClass())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectVersionStorageClass.wrap(value)
        )
    override def keyValue: Option[ObjectKey] =
      scala.Option(impl.key()).map(value => value: ObjectKey)
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def isLatestValue: Option[IsLatest] =
      scala.Option(impl.isLatest()).map(value => value: IsLatest)
    override def lastModifiedValue: Option[LastModified] =
      scala.Option(impl.lastModified()).map(value => value: LastModified)
    override def ownerValue
        : Option[io.github.vigoo.zioaws.s3.model.Owner.ReadOnly] = scala
      .Option(impl.owner())
      .map(value => io.github.vigoo.zioaws.s3.model.Owner.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ObjectVersion
  ): io.github.vigoo.zioaws.s3.model.ObjectVersion.ReadOnly = new Wrapper(impl)
}
