package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputLocation(
    s3: Option[io.github.vigoo.zioaws.s3.model.S3Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OutputLocation = {
    import OutputLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OutputLocation
      .builder()
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly =
    io.github.vigoo.zioaws.s3.model.OutputLocation.wrap(buildAwsValue())
}
object OutputLocation {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.OutputLocation] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.OutputLocation =
      io.github.vigoo.zioaws.s3.model
        .OutputLocation(s3Value.map(value => value.editable))
    def s3Value: Option[io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly]
    def s3: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3Value)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OutputLocation
  ) extends io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly {
    override def s3Value
        : Option[io.github.vigoo.zioaws.s3.model.S3Location.ReadOnly] = scala
      .Option(impl.s3())
      .map(value => io.github.vigoo.zioaws.s3.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OutputLocation
  ): io.github.vigoo.zioaws.s3.model.OutputLocation.ReadOnly = new Wrapper(impl)
}
