package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class OutputSerialization(
    csv: Option[io.github.vigoo.zioaws.s3.model.CSVOutput] = None,
    json: Option[io.github.vigoo.zioaws.s3.model.JSONOutput] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OutputSerialization = {
    import OutputSerialization.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OutputSerialization
      .builder()
      .optionallyWith(csv.map(value => value.buildAwsValue()))(_.csv)
      .optionallyWith(json.map(value => value.buildAwsValue()))(_.json)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly =
    io.github.vigoo.zioaws.s3.model.OutputSerialization.wrap(buildAwsValue())
}
object OutputSerialization {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OutputSerialization
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.OutputSerialization =
      io.github.vigoo.zioaws.s3.model.OutputSerialization(
        csvValue.map(value => value.editable),
        jsonValue.map(value => value.editable)
      )
    def csvValue: Option[io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly]
    def jsonValue: Option[io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly]
    def csv: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly
    ] = AwsError.unwrapOptionField("csv", csvValue)
    def json: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly
    ] = AwsError.unwrapOptionField("json", jsonValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OutputSerialization
  ) extends io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly {
    override def csvValue
        : Option[io.github.vigoo.zioaws.s3.model.CSVOutput.ReadOnly] = scala
      .Option(impl.csv())
      .map(value => io.github.vigoo.zioaws.s3.model.CSVOutput.wrap(value))
    override def jsonValue
        : Option[io.github.vigoo.zioaws.s3.model.JSONOutput.ReadOnly] = scala
      .Option(impl.json())
      .map(value => io.github.vigoo.zioaws.s3.model.JSONOutput.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OutputSerialization
  ): io.github.vigoo.zioaws.s3.model.OutputSerialization.ReadOnly = new Wrapper(
    impl
  )
}
