package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{ID, DisplayName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Owner(
    displayName: Option[DisplayName] = None,
    id: Option[ID] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Owner = {
    import Owner.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Owner
      .builder()
      .optionallyWith(displayName.map(value => value: java.lang.String))(
        _.displayName
      )
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Owner.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Owner.wrap(buildAwsValue())
}
object Owner {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Owner] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Owner =
      io.github.vigoo.zioaws.s3.model.Owner(
        displayNameValue.map(value => value),
        idValue.map(value => value)
      )
    def displayNameValue: Option[DisplayName]
    def idValue: Option[ID]
    def displayName: ZIO[Any, AwsError, DisplayName] =
      AwsError.unwrapOptionField("displayName", displayNameValue)
    def id: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", idValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Owner)
      extends io.github.vigoo.zioaws.s3.model.Owner.ReadOnly {
    override def displayNameValue: Option[DisplayName] =
      scala.Option(impl.displayName()).map(value => value: DisplayName)
    override def idValue: Option[ID] =
      scala.Option(impl.id()).map(value => value: ID)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Owner
  ): io.github.vigoo.zioaws.s3.model.Owner.ReadOnly = new Wrapper(impl)
}
