package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OwnershipControls(
    rules: Iterable[io.github.vigoo.zioaws.s3.model.OwnershipControlsRule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OwnershipControls = {
    import OwnershipControls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OwnershipControls
      .builder()
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly =
    io.github.vigoo.zioaws.s3.model.OwnershipControls.wrap(buildAwsValue())
}
object OwnershipControls {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OwnershipControls
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.OwnershipControls =
      io.github.vigoo.zioaws.s3.model.OwnershipControls(rulesValue.map { item =>
        item.editable
      })
    def rulesValue
        : List[io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly]
    def rules: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly
    ]] = ZIO.succeed(rulesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControls
  ) extends io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly {
    override def rulesValue
        : List[io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControls
  ): io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly = new Wrapper(
    impl
  )
}
