package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OwnershipControlsRule(
    objectOwnership: io.github.vigoo.zioaws.s3.model.ObjectOwnership
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.OwnershipControlsRule = {
    import OwnershipControlsRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.OwnershipControlsRule
      .builder()
      .objectOwnership(objectOwnership.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly =
    io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.wrap(buildAwsValue())
}
object OwnershipControlsRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.OwnershipControlsRule =
      io.github.vigoo.zioaws.s3.model
        .OwnershipControlsRule(objectOwnershipValue)
    def objectOwnershipValue: io.github.vigoo.zioaws.s3.model.ObjectOwnership
    def objectOwnership
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.ObjectOwnership] =
      ZIO.succeed(objectOwnershipValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ) extends io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly {
    override def objectOwnershipValue
        : io.github.vigoo.zioaws.s3.model.ObjectOwnership =
      io.github.vigoo.zioaws.s3.model.ObjectOwnership
        .wrap(impl.objectOwnership())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.OwnershipControlsRule
  ): io.github.vigoo.zioaws.s3.model.OwnershipControlsRule.ReadOnly =
    new Wrapper(impl)
}
