package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.IsPublic
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PolicyStatus(isPublic: Option[IsPublic] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.PolicyStatus = {
    import PolicyStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PolicyStatus
      .builder()
      .optionallyWith(isPublic.map(value => value: java.lang.Boolean))(
        _.isPublic
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PolicyStatus.wrap(buildAwsValue())
}
object PolicyStatus {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.PolicyStatus] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PolicyStatus =
      io.github.vigoo.zioaws.s3.model
        .PolicyStatus(isPublicValue.map(value => value))
    def isPublicValue: Option[IsPublic]
    def isPublic: ZIO[Any, AwsError, IsPublic] =
      AwsError.unwrapOptionField("isPublic", isPublicValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PolicyStatus
  ) extends io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly {
    override def isPublicValue: Option[IsPublic] =
      scala.Option(impl.isPublic()).map(value => value: IsPublic)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PolicyStatus
  ): io.github.vigoo.zioaws.s3.model.PolicyStatus.ReadOnly = new Wrapper(impl)
}
