package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Setting
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PublicAccessBlockConfiguration(
    blockPublicAcls: Option[Setting] = None,
    ignorePublicAcls: Option[Setting] = None,
    blockPublicPolicy: Option[Setting] = None,
    restrictPublicBuckets: Option[Setting] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration = {
    import PublicAccessBlockConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration
      .builder()
      .optionallyWith(blockPublicAcls.map(value => value: java.lang.Boolean))(
        _.blockPublicAcls
      )
      .optionallyWith(ignorePublicAcls.map(value => value: java.lang.Boolean))(
        _.ignorePublicAcls
      )
      .optionallyWith(blockPublicPolicy.map(value => value: java.lang.Boolean))(
        _.blockPublicPolicy
      )
      .optionallyWith(
        restrictPublicBuckets.map(value => value: java.lang.Boolean)
      )(_.restrictPublicBuckets)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration
      .wrap(buildAwsValue())
}
object PublicAccessBlockConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration =
      io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration(
        blockPublicAclsValue.map(value => value),
        ignorePublicAclsValue.map(value => value),
        blockPublicPolicyValue.map(value => value),
        restrictPublicBucketsValue.map(value => value)
      )
    def blockPublicAclsValue: Option[Setting]
    def ignorePublicAclsValue: Option[Setting]
    def blockPublicPolicyValue: Option[Setting]
    def restrictPublicBucketsValue: Option[Setting]
    def blockPublicAcls: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("blockPublicAcls", blockPublicAclsValue)
    def ignorePublicAcls: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("ignorePublicAcls", ignorePublicAclsValue)
    def blockPublicPolicy: ZIO[Any, AwsError, Setting] =
      AwsError.unwrapOptionField("blockPublicPolicy", blockPublicPolicyValue)
    def restrictPublicBuckets: ZIO[Any, AwsError, Setting] = AwsError
      .unwrapOptionField("restrictPublicBuckets", restrictPublicBucketsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly {
    override def blockPublicAclsValue: Option[Setting] =
      scala.Option(impl.blockPublicAcls()).map(value => value: Setting)
    override def ignorePublicAclsValue: Option[Setting] =
      scala.Option(impl.ignorePublicAcls()).map(value => value: Setting)
    override def blockPublicPolicyValue: Option[Setting] =
      scala.Option(impl.blockPublicPolicy()).map(value => value: Setting)
    override def restrictPublicBucketsValue: Option[Setting] =
      scala.Option(impl.restrictPublicBuckets()).map(value => value: Setting)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PublicAccessBlockConfiguration
  ): io.github.vigoo.zioaws.s3.model.PublicAccessBlockConfiguration.ReadOnly =
    new Wrapper(impl)
}
