package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketAccelerateConfigurationRequest(
    bucket: BucketName,
    accelerateConfiguration: io.github.vigoo.zioaws.s3.model.AccelerateConfiguration,
    expectedBucketOwner: Option[AccountId] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest = {
    import PutBucketAccelerateConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .accelerateConfiguration(accelerateConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketAccelerateConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest(
        bucketValue,
        accelerateConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value),
        checksumAlgorithmValue.map(value => value)
      )
    def bucketValue: BucketName
    def accelerateConfigurationValue
        : io.github.vigoo.zioaws.s3.model.AccelerateConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def accelerateConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.AccelerateConfiguration.ReadOnly
    ] = ZIO.succeed(accelerateConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def accelerateConfigurationValue
        : io.github.vigoo.zioaws.s3.model.AccelerateConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.AccelerateConfiguration
        .wrap(impl.accelerateConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAccelerateConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketAccelerateConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
