package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentMD5,
  GrantRead,
  GrantReadACP,
  AccountId,
  GrantWriteACP,
  GrantFullControl,
  BucketName,
  GrantWrite
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketAclRequest(
    acl: Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL] = None,
    accessControlPolicy: Option[
      io.github.vigoo.zioaws.s3.model.AccessControlPolicy
    ] = None,
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWrite: Option[GrantWrite] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAclRequest = {
    import PutBucketAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAclRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .optionallyWith(accessControlPolicy.map(value => value.buildAwsValue()))(
        _.accessControlPolicy
      )
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(grantFullControl.map(value => value: java.lang.String))(
        _.grantFullControl
      )
      .optionallyWith(grantRead.map(value => value: java.lang.String))(
        _.grantRead
      )
      .optionallyWith(grantReadACP.map(value => value: java.lang.String))(
        _.grantReadACP
      )
      .optionallyWith(grantWrite.map(value => value: java.lang.String))(
        _.grantWrite
      )
      .optionallyWith(grantWriteACP.map(value => value: java.lang.String))(
        _.grantWriteACP
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketAclRequest.wrap(buildAwsValue())
}
object PutBucketAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketAclRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketAclRequest(
        aclValue.map(value => value),
        accessControlPolicyValue.map(value => value.editable),
        bucketValue,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        grantFullControlValue.map(value => value),
        grantReadValue.map(value => value),
        grantReadACPValue.map(value => value),
        grantWriteValue.map(value => value),
        grantWriteACPValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def aclValue: Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL]
    def accessControlPolicyValue
        : Option[io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly]
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def grantFullControlValue: Option[GrantFullControl]
    def grantReadValue: Option[GrantRead]
    def grantReadACPValue: Option[GrantReadACP]
    def grantWriteValue: Option[GrantWrite]
    def grantWriteACPValue: Option[GrantWriteACP]
    def expectedBucketOwnerValue: Option[AccountId]
    def acl
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.BucketCannedACL] =
      AwsError.unwrapOptionField("acl", aclValue)
    def accessControlPolicy: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly
    ] = AwsError.unwrapOptionField(
      "accessControlPolicy",
      accessControlPolicyValue
    )
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def grantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControlValue)
    def grantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantReadValue)
    def grantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACPValue)
    def grantWrite: ZIO[Any, AwsError, GrantWrite] =
      AwsError.unwrapOptionField("grantWrite", grantWriteValue)
    def grantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACPValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketAclRequest.ReadOnly {
    override def aclValue
        : Option[io.github.vigoo.zioaws.s3.model.BucketCannedACL] = scala
      .Option(impl.acl())
      .map(value => io.github.vigoo.zioaws.s3.model.BucketCannedACL.wrap(value))
    override def accessControlPolicyValue
        : Option[io.github.vigoo.zioaws.s3.model.AccessControlPolicy.ReadOnly] =
      scala
        .Option(impl.accessControlPolicy())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.AccessControlPolicy.wrap(value)
        )
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def grantFullControlValue: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => value: GrantFullControl)
    override def grantReadValue: Option[GrantRead] =
      scala.Option(impl.grantRead()).map(value => value: GrantRead)
    override def grantReadACPValue: Option[GrantReadACP] =
      scala.Option(impl.grantReadACP()).map(value => value: GrantReadACP)
    override def grantWriteValue: Option[GrantWrite] =
      scala.Option(impl.grantWrite()).map(value => value: GrantWrite)
    override def grantWriteACPValue: Option[GrantWriteACP] =
      scala.Option(impl.grantWriteACP()).map(value => value: GrantWriteACP)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAclRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketAclRequest.ReadOnly = new Wrapper(
    impl
  )
}
