package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  AnalyticsId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketAnalyticsConfigurationRequest(
    bucket: BucketName,
    id: AnalyticsId,
    analyticsConfiguration: io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest = {
    import PutBucketAnalyticsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .analyticsConfiguration(analyticsConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketAnalyticsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest(
        bucketValue,
        idValue,
        analyticsConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: AnalyticsId
    def analyticsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, AnalyticsId] = ZIO.succeed(idValue)
    def analyticsConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly
    ] = ZIO.succeed(analyticsConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: AnalyticsId = impl.id(): AnalyticsId
    override def analyticsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.AnalyticsConfiguration
        .wrap(impl.analyticsConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketAnalyticsConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketAnalyticsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
