package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketCorsRequest(
    bucket: BucketName,
    corsConfiguration: io.github.vigoo.zioaws.s3.model.CORSConfiguration,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketCorsRequest = {
    import PutBucketCorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketCorsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .corsConfiguration(corsConfiguration.buildAwsValue())
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest.wrap(buildAwsValue())
}
object PutBucketCorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketCorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest(
        bucketValue,
        corsConfigurationValue.editable,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def corsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def corsConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly
    ] = ZIO.succeed(corsConfigurationValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketCorsRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def corsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.CORSConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.CORSConfiguration
        .wrap(impl.corsConfiguration())
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketCorsRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketCorsRequest.ReadOnly =
    new Wrapper(impl)
}
