package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketEncryptionRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    serverSideEncryptionConfiguration: io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest = {
    import PutBucketEncryptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .serverSideEncryptionConfiguration(
        serverSideEncryptionConfiguration.buildAwsValue()
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest
      .wrap(buildAwsValue())
}
object PutBucketEncryptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest(
        bucketValue,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        serverSideEncryptionConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def serverSideEncryptionConfigurationValue
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def serverSideEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(serverSideEncryptionConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def serverSideEncryptionConfigurationValue
        : io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.ServerSideEncryptionConfiguration
        .wrap(impl.serverSideEncryptionConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketEncryptionRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketEncryptionRequest.ReadOnly =
    new Wrapper(impl)
}
