package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  IntelligentTieringId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PutBucketIntelligentTieringConfigurationRequest(
    bucket: BucketName,
    id: IntelligentTieringId,
    intelligentTieringConfiguration: io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest = {
    import PutBucketIntelligentTieringConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .intelligentTieringConfiguration(
        intelligentTieringConfiguration.buildAwsValue()
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketIntelligentTieringConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest =
      io.github.vigoo.zioaws.s3.model
        .PutBucketIntelligentTieringConfigurationRequest(
          bucketValue,
          idValue,
          intelligentTieringConfigurationValue.editable
        )
    def bucketValue: BucketName
    def idValue: IntelligentTieringId
    def intelligentTieringConfigurationValue
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, IntelligentTieringId] = ZIO.succeed(idValue)
    def intelligentTieringConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly
    ] = ZIO.succeed(intelligentTieringConfigurationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: IntelligentTieringId = impl.id(): IntelligentTieringId
    override def intelligentTieringConfigurationValue
        : io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.IntelligentTieringConfiguration
        .wrap(impl.intelligentTieringConfiguration())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketIntelligentTieringConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketIntelligentTieringConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
