package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  InventoryId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketInventoryConfigurationRequest(
    bucket: BucketName,
    id: InventoryId,
    inventoryConfiguration: io.github.vigoo.zioaws.s3.model.InventoryConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest = {
    import PutBucketInventoryConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .inventoryConfiguration(inventoryConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketInventoryConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest(
        bucketValue,
        idValue,
        inventoryConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: InventoryId
    def inventoryConfigurationValue
        : io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, InventoryId] = ZIO.succeed(idValue)
    def inventoryConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly
    ] = ZIO.succeed(inventoryConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: InventoryId = impl.id(): InventoryId
    override def inventoryConfigurationValue
        : io.github.vigoo.zioaws.s3.model.InventoryConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.InventoryConfiguration
        .wrap(impl.inventoryConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketInventoryConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketInventoryConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
