package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{AccountId, BucketName}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketLifecycleConfigurationRequest(
    bucket: BucketName,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    lifecycleConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest = {
    import PutBucketLifecycleConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        lifecycleConfiguration.map(value => value.buildAwsValue())
      )(_.lifecycleConfiguration)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketLifecycleConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest(
        bucketValue,
        checksumAlgorithmValue.map(value => value),
        lifecycleConfigurationValue.map(value => value.editable),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def lifecycleConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly
    ]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def lifecycleConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "lifecycleConfiguration",
      lifecycleConfigurationValue
    )
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def lifecycleConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.ReadOnly
    ] = scala
      .Option(impl.lifecycleConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.BucketLifecycleConfiguration.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketLifecycleConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
