package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketLoggingRequest(
    bucket: BucketName,
    bucketLoggingStatus: io.github.vigoo.zioaws.s3.model.BucketLoggingStatus,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest = {
    import PutBucketLoggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .bucketLoggingStatus(bucketLoggingStatus.buildAwsValue())
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest
      .wrap(buildAwsValue())
}
object PutBucketLoggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest(
        bucketValue,
        bucketLoggingStatusValue.editable,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def bucketLoggingStatusValue
        : io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def bucketLoggingStatus: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly
    ] = ZIO.succeed(bucketLoggingStatusValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def bucketLoggingStatusValue
        : io.github.vigoo.zioaws.s3.model.BucketLoggingStatus.ReadOnly =
      io.github.vigoo.zioaws.s3.model.BucketLoggingStatus
        .wrap(impl.bucketLoggingStatus())
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketLoggingRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketLoggingRequest.ReadOnly =
    new Wrapper(impl)
}
