package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  MetricsId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketMetricsConfigurationRequest(
    bucket: BucketName,
    id: MetricsId,
    metricsConfiguration: io.github.vigoo.zioaws.s3.model.MetricsConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest = {
    import PutBucketMetricsConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .id(id: java.lang.String)
      .metricsConfiguration(metricsConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketMetricsConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest(
        bucketValue,
        idValue,
        metricsConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def idValue: MetricsId
    def metricsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def id: ZIO[Any, Nothing, MetricsId] = ZIO.succeed(idValue)
    def metricsConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly
    ] = ZIO.succeed(metricsConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def idValue: MetricsId = impl.id(): MetricsId
    override def metricsConfigurationValue
        : io.github.vigoo.zioaws.s3.model.MetricsConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.MetricsConfiguration
        .wrap(impl.metricsConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketMetricsConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketMetricsConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
