package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  SkipValidation,
  AccountId,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketNotificationConfigurationRequest(
    bucket: BucketName,
    notificationConfiguration: io.github.vigoo.zioaws.s3.model.NotificationConfiguration,
    expectedBucketOwner: Option[AccountId] = None,
    skipDestinationValidation: Option[SkipValidation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest = {
    import PutBucketNotificationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .notificationConfiguration(notificationConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(
        skipDestinationValidation.map(value => value: java.lang.Boolean)
      )(_.skipDestinationValidation)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest
      .wrap(buildAwsValue())
}
object PutBucketNotificationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest(
        bucketValue,
        notificationConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value),
        skipDestinationValidationValue.map(value => value)
      )
    def bucketValue: BucketName
    def notificationConfigurationValue
        : io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def skipDestinationValidationValue: Option[SkipValidation]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def notificationConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly
    ] = ZIO.succeed(notificationConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def skipDestinationValidation: ZIO[Any, AwsError, SkipValidation] =
      AwsError.unwrapOptionField(
        "skipDestinationValidation",
        skipDestinationValidationValue
      )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def notificationConfigurationValue
        : io.github.vigoo.zioaws.s3.model.NotificationConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.NotificationConfiguration
        .wrap(impl.notificationConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def skipDestinationValidationValue: Option[SkipValidation] = scala
      .Option(impl.skipDestinationValidation())
      .map(value => value: SkipValidation)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketNotificationConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketNotificationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
