package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketOwnershipControlsRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    expectedBucketOwner: Option[AccountId] = None,
    ownershipControls: io.github.vigoo.zioaws.s3.model.OwnershipControls
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest = {
    import PutBucketOwnershipControlsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .ownershipControls(ownershipControls.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest
      .wrap(buildAwsValue())
}
object PutBucketOwnershipControlsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest(
        bucketValue,
        contentMD5Value.map(value => value),
        expectedBucketOwnerValue.map(value => value),
        ownershipControlsValue.editable
      )
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def expectedBucketOwnerValue: Option[AccountId]
    def ownershipControlsValue
        : io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def ownershipControls: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly
    ] = ZIO.succeed(ownershipControlsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def ownershipControlsValue
        : io.github.vigoo.zioaws.s3.model.OwnershipControls.ReadOnly =
      io.github.vigoo.zioaws.s3.model.OwnershipControls
        .wrap(impl.ownershipControls())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketOwnershipControlsRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketOwnershipControlsRequest.ReadOnly =
    new Wrapper(impl)
}
