package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ConfirmRemoveSelfBucketAccess,
  Policy,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketPolicyRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    confirmRemoveSelfBucketAccess: Option[ConfirmRemoveSelfBucketAccess] = None,
    policy: Policy,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest = {
    import PutBucketPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        confirmRemoveSelfBucketAccess.map(value => value: java.lang.Boolean)
      )(_.confirmRemoveSelfBucketAccess)
      .policy(policy: java.lang.String)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest.wrap(buildAwsValue())
}
object PutBucketPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest(
        bucketValue,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        confirmRemoveSelfBucketAccessValue.map(value => value),
        policyValue,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def confirmRemoveSelfBucketAccessValue
        : Option[ConfirmRemoveSelfBucketAccess]
    def policyValue: Policy
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def confirmRemoveSelfBucketAccess
        : ZIO[Any, AwsError, ConfirmRemoveSelfBucketAccess] =
      AwsError.unwrapOptionField(
        "confirmRemoveSelfBucketAccess",
        confirmRemoveSelfBucketAccessValue
      )
    def policy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policyValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def confirmRemoveSelfBucketAccessValue
        : Option[ConfirmRemoveSelfBucketAccess] = scala
      .Option(impl.confirmRemoveSelfBucketAccess())
      .map(value => value: ConfirmRemoveSelfBucketAccess)
    override def policyValue: Policy = impl.policy(): Policy
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketPolicyRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
