package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ObjectLockToken,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketReplicationRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    replicationConfiguration: io.github.vigoo.zioaws.s3.model.ReplicationConfiguration,
    token: Option[ObjectLockToken] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest = {
    import PutBucketReplicationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .replicationConfiguration(replicationConfiguration.buildAwsValue())
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest
      .wrap(buildAwsValue())
}
object PutBucketReplicationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest(
        bucketValue,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        replicationConfigurationValue.editable,
        tokenValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def replicationConfigurationValue
        : io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly
    def tokenValue: Option[ObjectLockToken]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def replicationConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly
    ] = ZIO.succeed(replicationConfigurationValue)
    def token: ZIO[Any, AwsError, ObjectLockToken] =
      AwsError.unwrapOptionField("token", tokenValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def replicationConfigurationValue
        : io.github.vigoo.zioaws.s3.model.ReplicationConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.ReplicationConfiguration
        .wrap(impl.replicationConfiguration())
    override def tokenValue: Option[ObjectLockToken] =
      scala.Option(impl.token()).map(value => value: ObjectLockToken)
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketReplicationRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketReplicationRequest.ReadOnly =
    new Wrapper(impl)
}
