package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  MFA,
  ContentMD5,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutBucketVersioningRequest(
    bucket: BucketName,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    mfa: Option[MFA] = None,
    versioningConfiguration: io.github.vigoo.zioaws.s3.model.VersioningConfiguration,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest = {
    import PutBucketVersioningRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(mfa.map(value => value: java.lang.String))(_.mfa)
      .versioningConfiguration(versioningConfiguration.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest
      .wrap(buildAwsValue())
}
object PutBucketVersioningRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest =
      io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest(
        bucketValue,
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        mfaValue.map(value => value),
        versioningConfigurationValue.editable,
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def mfaValue: Option[MFA]
    def versioningConfigurationValue
        : io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def mfa: ZIO[Any, AwsError, MFA] =
      AwsError.unwrapOptionField("mfa", mfaValue)
    def versioningConfiguration: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly
    ] = ZIO.succeed(versioningConfigurationValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def mfaValue: Option[MFA] =
      scala.Option(impl.mfa()).map(value => value: MFA)
    override def versioningConfigurationValue
        : io.github.vigoo.zioaws.s3.model.VersioningConfiguration.ReadOnly =
      io.github.vigoo.zioaws.s3.model.VersioningConfiguration
        .wrap(impl.versioningConfiguration())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutBucketVersioningRequest
  ): io.github.vigoo.zioaws.s3.model.PutBucketVersioningRequest.ReadOnly =
    new Wrapper(impl)
}
