package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectLegalHoldRequest(
    bucket: BucketName,
    key: ObjectKey,
    legalHold: Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold] =
      None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    versionId: Option[ObjectVersionId] = None,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest = {
    import PutObjectLegalHoldRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(legalHold.map(value => value.buildAwsValue()))(
        _.legalHold
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest
      .wrap(buildAwsValue())
}
object PutObjectLegalHoldRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest =
      io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest(
        bucketValue,
        keyValue,
        legalHoldValue.map(value => value.editable),
        requestPayerValue.map(value => value),
        versionIdValue.map(value => value),
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def legalHoldValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def versionIdValue: Option[ObjectVersionId]
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def legalHold: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly
    ] = AwsError.unwrapOptionField("legalHold", legalHoldValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def legalHoldValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.ReadOnly] =
      scala
        .Option(impl.legalHold())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHold.wrap(value)
        )
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldRequest
  ): io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldRequest.ReadOnly =
    new Wrapper(impl)
}
