package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectLegalHoldResponse(
    requestCharged: Option[io.github.vigoo.zioaws.s3.model.RequestCharged] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse = {
    import PutObjectLegalHoldResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
      .builder()
      .optionallyWith(requestCharged.map(value => value.unwrap))(
        _.requestCharged
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse
      .wrap(buildAwsValue())
}
object PutObjectLegalHoldResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse =
      io.github.vigoo.zioaws.s3.model
        .PutObjectLegalHoldResponse(requestChargedValue.map(value => value))
    def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged]
    def requestCharged
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestCharged] =
      AwsError.unwrapOptionField("requestCharged", requestChargedValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly {
    override def requestChargedValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestCharged] = scala
      .Option(impl.requestCharged())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestCharged.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLegalHoldResponse
  ): io.github.vigoo.zioaws.s3.model.PutObjectLegalHoldResponse.ReadOnly =
    new Wrapper(impl)
}
