package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  AccountId,
  ContentMD5,
  ObjectLockToken,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectLockConfigurationRequest(
    bucket: BucketName,
    objectLockConfiguration: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration
    ] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    token: Option[ObjectLockToken] = None,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest = {
    import PutObjectLockConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .optionallyWith(
        objectLockConfiguration.map(value => value.buildAwsValue())
      )(_.objectLockConfiguration)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(token.map(value => value: java.lang.String))(_.token)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest
      .wrap(buildAwsValue())
}
object PutObjectLockConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest =
      io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest(
        bucketValue,
        objectLockConfigurationValue.map(value => value.editable),
        requestPayerValue.map(value => value),
        tokenValue.map(value => value),
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def objectLockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def tokenValue: Option[ObjectLockToken]
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def objectLockConfiguration: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "objectLockConfiguration",
      objectLockConfigurationValue
    )
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def token: ZIO[Any, AwsError, ObjectLockToken] =
      AwsError.unwrapOptionField("token", tokenValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def objectLockConfigurationValue: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.ReadOnly
    ] = scala
      .Option(impl.objectLockConfiguration())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ObjectLockConfiguration.wrap(value)
      )
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def tokenValue: Option[ObjectLockToken] =
      scala.Option(impl.token()).map(value => value: ObjectLockToken)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectLockConfigurationRequest
  ): io.github.vigoo.zioaws.s3.model.PutObjectLockConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
