package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  SSECustomerKey,
  ContentType,
  CacheControl,
  ContentMD5,
  WebsiteRedirectLocation,
  GrantRead,
  ContentDisposition,
  ContentLanguage,
  GrantReadACP,
  ContentLength,
  AccountId,
  SSECustomerAlgorithm,
  SSECustomerKeyMD5,
  SSEKMSEncryptionContext,
  ChecksumSHA256,
  Expires,
  ContentEncoding,
  ChecksumCRC32C,
  ObjectKey,
  GrantWriteACP,
  ChecksumCRC32,
  ChecksumSHA1,
  GrantFullControl,
  BucketName,
  SSEKMSKeyId,
  MetadataValue,
  TaggingHeader,
  ObjectLockRetainUntilDate,
  MetadataKey,
  BucketKeyEnabled
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectRequest(
    acl: Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL] = None,
    bucket: BucketName,
    cacheControl: Option[CacheControl] = None,
    contentDisposition: Option[ContentDisposition] = None,
    contentEncoding: Option[ContentEncoding] = None,
    contentLanguage: Option[ContentLanguage] = None,
    contentLength: Option[ContentLength] = None,
    contentMD5: Option[ContentMD5] = None,
    contentType: Option[ContentType] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    checksumCRC32: Option[ChecksumCRC32] = None,
    checksumCRC32C: Option[ChecksumCRC32C] = None,
    checksumSHA1: Option[ChecksumSHA1] = None,
    checksumSHA256: Option[ChecksumSHA256] = None,
    expires: Option[Expires] = None,
    grantFullControl: Option[GrantFullControl] = None,
    grantRead: Option[GrantRead] = None,
    grantReadACP: Option[GrantReadACP] = None,
    grantWriteACP: Option[GrantWriteACP] = None,
    key: ObjectKey,
    metadata: Option[Map[MetadataKey, MetadataValue]] = None,
    serverSideEncryption: Option[
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = None,
    storageClass: Option[io.github.vigoo.zioaws.s3.model.StorageClass] = None,
    websiteRedirectLocation: Option[WebsiteRedirectLocation] = None,
    sseCustomerAlgorithm: Option[SSECustomerAlgorithm] = None,
    sseCustomerKey: Option[SSECustomerKey] = None,
    sseCustomerKeyMD5: Option[SSECustomerKeyMD5] = None,
    ssekmsKeyId: Option[SSEKMSKeyId] = None,
    ssekmsEncryptionContext: Option[SSEKMSEncryptionContext] = None,
    bucketKeyEnabled: Option[BucketKeyEnabled] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    tagging: Option[TaggingHeader] = None,
    objectLockMode: Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      None,
    objectLockRetainUntilDate: Option[ObjectLockRetainUntilDate] = None,
    objectLockLegalHoldStatus: Option[
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRequest = {
    import PutObjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRequest
      .builder()
      .optionallyWith(acl.map(value => value.unwrap))(_.acl)
      .bucket(bucket: java.lang.String)
      .optionallyWith(cacheControl.map(value => value: java.lang.String))(
        _.cacheControl
      )
      .optionallyWith(contentDisposition.map(value => value: java.lang.String))(
        _.contentDisposition
      )
      .optionallyWith(contentEncoding.map(value => value: java.lang.String))(
        _.contentEncoding
      )
      .optionallyWith(contentLanguage.map(value => value: java.lang.String))(
        _.contentLanguage
      )
      .optionallyWith(contentLength.map(value => value: java.lang.Long))(
        _.contentLength
      )
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(contentType.map(value => value: java.lang.String))(
        _.contentType
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(checksumCRC32.map(value => value: java.lang.String))(
        _.checksumCRC32
      )
      .optionallyWith(checksumCRC32C.map(value => value: java.lang.String))(
        _.checksumCRC32C
      )
      .optionallyWith(checksumSHA1.map(value => value: java.lang.String))(
        _.checksumSHA1
      )
      .optionallyWith(checksumSHA256.map(value => value: java.lang.String))(
        _.checksumSHA256
      )
      .optionallyWith(expires.map(value => value: Instant))(_.expires)
      .optionallyWith(grantFullControl.map(value => value: java.lang.String))(
        _.grantFullControl
      )
      .optionallyWith(grantRead.map(value => value: java.lang.String))(
        _.grantRead
      )
      .optionallyWith(grantReadACP.map(value => value: java.lang.String))(
        _.grantReadACP
      )
      .optionallyWith(grantWriteACP.map(value => value: java.lang.String))(
        _.grantWriteACP
      )
      .key(key: java.lang.String)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .optionallyWith(serverSideEncryption.map(value => value.unwrap))(
        _.serverSideEncryption
      )
      .optionallyWith(storageClass.map(value => value.unwrap))(_.storageClass)
      .optionallyWith(
        websiteRedirectLocation.map(value => value: java.lang.String)
      )(_.websiteRedirectLocation)
      .optionallyWith(
        sseCustomerAlgorithm.map(value => value: java.lang.String)
      )(_.sseCustomerAlgorithm)
      .optionallyWith(sseCustomerKey.map(value => value: java.lang.String))(
        _.sseCustomerKey
      )
      .optionallyWith(sseCustomerKeyMD5.map(value => value: java.lang.String))(
        _.sseCustomerKeyMD5
      )
      .optionallyWith(ssekmsKeyId.map(value => value: java.lang.String))(
        _.ssekmsKeyId
      )
      .optionallyWith(
        ssekmsEncryptionContext.map(value => value: java.lang.String)
      )(_.ssekmsEncryptionContext)
      .optionallyWith(bucketKeyEnabled.map(value => value: java.lang.Boolean))(
        _.bucketKeyEnabled
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(tagging.map(value => value: java.lang.String))(_.tagging)
      .optionallyWith(objectLockMode.map(value => value.unwrap))(
        _.objectLockMode
      )
      .optionallyWith(objectLockRetainUntilDate.map(value => value: Instant))(
        _.objectLockRetainUntilDate
      )
      .optionallyWith(objectLockLegalHoldStatus.map(value => value.unwrap))(
        _.objectLockLegalHoldStatus
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.PutObjectRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectRequest.wrap(buildAwsValue())
}
object PutObjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectRequest =
      io.github.vigoo.zioaws.s3.model.PutObjectRequest(
        aclValue.map(value => value),
        bucketValue,
        cacheControlValue.map(value => value),
        contentDispositionValue.map(value => value),
        contentEncodingValue.map(value => value),
        contentLanguageValue.map(value => value),
        contentLengthValue.map(value => value),
        contentMD5Value.map(value => value),
        contentTypeValue.map(value => value),
        checksumAlgorithmValue.map(value => value),
        checksumCRC32Value.map(value => value),
        checksumCRC32CValue.map(value => value),
        checksumSHA1Value.map(value => value),
        checksumSHA256Value.map(value => value),
        expiresValue.map(value => value),
        grantFullControlValue.map(value => value),
        grantReadValue.map(value => value),
        grantReadACPValue.map(value => value),
        grantWriteACPValue.map(value => value),
        keyValue,
        metadataValue.map(value => value),
        serverSideEncryptionValue.map(value => value),
        storageClassValue.map(value => value),
        websiteRedirectLocationValue.map(value => value),
        sseCustomerAlgorithmValue.map(value => value),
        sseCustomerKeyValue.map(value => value),
        sseCustomerKeyMD5Value.map(value => value),
        ssekmsKeyIdValue.map(value => value),
        ssekmsEncryptionContextValue.map(value => value),
        bucketKeyEnabledValue.map(value => value),
        requestPayerValue.map(value => value),
        taggingValue.map(value => value),
        objectLockModeValue.map(value => value),
        objectLockRetainUntilDateValue.map(value => value),
        objectLockLegalHoldStatusValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def aclValue: Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL]
    def bucketValue: BucketName
    def cacheControlValue: Option[CacheControl]
    def contentDispositionValue: Option[ContentDisposition]
    def contentEncodingValue: Option[ContentEncoding]
    def contentLanguageValue: Option[ContentLanguage]
    def contentLengthValue: Option[ContentLength]
    def contentMD5Value: Option[ContentMD5]
    def contentTypeValue: Option[ContentType]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def checksumCRC32Value: Option[ChecksumCRC32]
    def checksumCRC32CValue: Option[ChecksumCRC32C]
    def checksumSHA1Value: Option[ChecksumSHA1]
    def checksumSHA256Value: Option[ChecksumSHA256]
    def expiresValue: Option[Expires]
    def grantFullControlValue: Option[GrantFullControl]
    def grantReadValue: Option[GrantRead]
    def grantReadACPValue: Option[GrantReadACP]
    def grantWriteACPValue: Option[GrantWriteACP]
    def keyValue: ObjectKey
    def metadataValue: Option[Map[MetadataKey, MetadataValue]]
    def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption]
    def storageClassValue: Option[io.github.vigoo.zioaws.s3.model.StorageClass]
    def websiteRedirectLocationValue: Option[WebsiteRedirectLocation]
    def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm]
    def sseCustomerKeyValue: Option[SSECustomerKey]
    def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5]
    def ssekmsKeyIdValue: Option[SSEKMSKeyId]
    def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext]
    def bucketKeyEnabledValue: Option[BucketKeyEnabled]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def taggingValue: Option[TaggingHeader]
    def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode]
    def objectLockRetainUntilDateValue: Option[ObjectLockRetainUntilDate]
    def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus]
    def expectedBucketOwnerValue: Option[AccountId]
    def acl
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectCannedACL] =
      AwsError.unwrapOptionField("acl", aclValue)
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def cacheControl: ZIO[Any, AwsError, CacheControl] =
      AwsError.unwrapOptionField("cacheControl", cacheControlValue)
    def contentDisposition: ZIO[Any, AwsError, ContentDisposition] =
      AwsError.unwrapOptionField("contentDisposition", contentDispositionValue)
    def contentEncoding: ZIO[Any, AwsError, ContentEncoding] =
      AwsError.unwrapOptionField("contentEncoding", contentEncodingValue)
    def contentLanguage: ZIO[Any, AwsError, ContentLanguage] =
      AwsError.unwrapOptionField("contentLanguage", contentLanguageValue)
    def contentLength: ZIO[Any, AwsError, ContentLength] =
      AwsError.unwrapOptionField("contentLength", contentLengthValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def contentType: ZIO[Any, AwsError, ContentType] =
      AwsError.unwrapOptionField("contentType", contentTypeValue)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def checksumCRC32: ZIO[Any, AwsError, ChecksumCRC32] =
      AwsError.unwrapOptionField("checksumCRC32", checksumCRC32Value)
    def checksumCRC32C: ZIO[Any, AwsError, ChecksumCRC32C] =
      AwsError.unwrapOptionField("checksumCRC32C", checksumCRC32CValue)
    def checksumSHA1: ZIO[Any, AwsError, ChecksumSHA1] =
      AwsError.unwrapOptionField("checksumSHA1", checksumSHA1Value)
    def checksumSHA256: ZIO[Any, AwsError, ChecksumSHA256] =
      AwsError.unwrapOptionField("checksumSHA256", checksumSHA256Value)
    def expires: ZIO[Any, AwsError, Expires] =
      AwsError.unwrapOptionField("expires", expiresValue)
    def grantFullControl: ZIO[Any, AwsError, GrantFullControl] =
      AwsError.unwrapOptionField("grantFullControl", grantFullControlValue)
    def grantRead: ZIO[Any, AwsError, GrantRead] =
      AwsError.unwrapOptionField("grantRead", grantReadValue)
    def grantReadACP: ZIO[Any, AwsError, GrantReadACP] =
      AwsError.unwrapOptionField("grantReadACP", grantReadACPValue)
    def grantWriteACP: ZIO[Any, AwsError, GrantWriteACP] =
      AwsError.unwrapOptionField("grantWriteACP", grantWriteACPValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def metadata: ZIO[Any, AwsError, Map[MetadataKey, MetadataValue]] =
      AwsError.unwrapOptionField("metadata", metadataValue)
    def serverSideEncryption: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ServerSideEncryption
    ] = AwsError.unwrapOptionField(
      "serverSideEncryption",
      serverSideEncryptionValue
    )
    def storageClass
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.StorageClass] =
      AwsError.unwrapOptionField("storageClass", storageClassValue)
    def websiteRedirectLocation: ZIO[Any, AwsError, WebsiteRedirectLocation] =
      AwsError.unwrapOptionField(
        "websiteRedirectLocation",
        websiteRedirectLocationValue
      )
    def sseCustomerAlgorithm: ZIO[Any, AwsError, SSECustomerAlgorithm] =
      AwsError.unwrapOptionField(
        "sseCustomerAlgorithm",
        sseCustomerAlgorithmValue
      )
    def sseCustomerKey: ZIO[Any, AwsError, SSECustomerKey] =
      AwsError.unwrapOptionField("sseCustomerKey", sseCustomerKeyValue)
    def sseCustomerKeyMD5: ZIO[Any, AwsError, SSECustomerKeyMD5] =
      AwsError.unwrapOptionField("sseCustomerKeyMD5", sseCustomerKeyMD5Value)
    def ssekmsKeyId: ZIO[Any, AwsError, SSEKMSKeyId] =
      AwsError.unwrapOptionField("ssekmsKeyId", ssekmsKeyIdValue)
    def ssekmsEncryptionContext: ZIO[Any, AwsError, SSEKMSEncryptionContext] =
      AwsError.unwrapOptionField(
        "ssekmsEncryptionContext",
        ssekmsEncryptionContextValue
      )
    def bucketKeyEnabled: ZIO[Any, AwsError, BucketKeyEnabled] =
      AwsError.unwrapOptionField("bucketKeyEnabled", bucketKeyEnabledValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def tagging: ZIO[Any, AwsError, TaggingHeader] =
      AwsError.unwrapOptionField("tagging", taggingValue)
    def objectLockMode
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.ObjectLockMode] =
      AwsError.unwrapOptionField("objectLockMode", objectLockModeValue)
    def objectLockRetainUntilDate
        : ZIO[Any, AwsError, ObjectLockRetainUntilDate] =
      AwsError.unwrapOptionField(
        "objectLockRetainUntilDate",
        objectLockRetainUntilDateValue
      )
    def objectLockLegalHoldStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus
    ] = AwsError.unwrapOptionField(
      "objectLockLegalHoldStatus",
      objectLockLegalHoldStatusValue
    )
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectRequest.ReadOnly {
    override def aclValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectCannedACL] = scala
      .Option(impl.acl())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectCannedACL.wrap(value))
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def cacheControlValue: Option[CacheControl] =
      scala.Option(impl.cacheControl()).map(value => value: CacheControl)
    override def contentDispositionValue: Option[ContentDisposition] = scala
      .Option(impl.contentDisposition())
      .map(value => value: ContentDisposition)
    override def contentEncodingValue: Option[ContentEncoding] =
      scala.Option(impl.contentEncoding()).map(value => value: ContentEncoding)
    override def contentLanguageValue: Option[ContentLanguage] =
      scala.Option(impl.contentLanguage()).map(value => value: ContentLanguage)
    override def contentLengthValue: Option[ContentLength] =
      scala.Option(impl.contentLength()).map(value => value: ContentLength)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def contentTypeValue: Option[ContentType] =
      scala.Option(impl.contentType()).map(value => value: ContentType)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def checksumCRC32Value: Option[ChecksumCRC32] =
      scala.Option(impl.checksumCRC32()).map(value => value: ChecksumCRC32)
    override def checksumCRC32CValue: Option[ChecksumCRC32C] =
      scala.Option(impl.checksumCRC32C()).map(value => value: ChecksumCRC32C)
    override def checksumSHA1Value: Option[ChecksumSHA1] =
      scala.Option(impl.checksumSHA1()).map(value => value: ChecksumSHA1)
    override def checksumSHA256Value: Option[ChecksumSHA256] =
      scala.Option(impl.checksumSHA256()).map(value => value: ChecksumSHA256)
    override def expiresValue: Option[Expires] =
      scala.Option(impl.expires()).map(value => value: Expires)
    override def grantFullControlValue: Option[GrantFullControl] = scala
      .Option(impl.grantFullControl())
      .map(value => value: GrantFullControl)
    override def grantReadValue: Option[GrantRead] =
      scala.Option(impl.grantRead()).map(value => value: GrantRead)
    override def grantReadACPValue: Option[GrantReadACP] =
      scala.Option(impl.grantReadACP()).map(value => value: GrantReadACP)
    override def grantWriteACPValue: Option[GrantWriteACP] =
      scala.Option(impl.grantWriteACP()).map(value => value: GrantWriteACP)
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def metadataValue: Option[Map[MetadataKey, MetadataValue]] = scala
      .Option(impl.metadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: MetadataKey) -> (value: MetadataValue)
          })
          .toMap
      )
    override def serverSideEncryptionValue
        : Option[io.github.vigoo.zioaws.s3.model.ServerSideEncryption] = scala
      .Option(impl.serverSideEncryption())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ServerSideEncryption.wrap(value)
      )
    override def storageClassValue
        : Option[io.github.vigoo.zioaws.s3.model.StorageClass] = scala
      .Option(impl.storageClass())
      .map(value => io.github.vigoo.zioaws.s3.model.StorageClass.wrap(value))
    override def websiteRedirectLocationValue: Option[WebsiteRedirectLocation] =
      scala
        .Option(impl.websiteRedirectLocation())
        .map(value => value: WebsiteRedirectLocation)
    override def sseCustomerAlgorithmValue: Option[SSECustomerAlgorithm] = scala
      .Option(impl.sseCustomerAlgorithm())
      .map(value => value: SSECustomerAlgorithm)
    override def sseCustomerKeyValue: Option[SSECustomerKey] =
      scala.Option(impl.sseCustomerKey()).map(value => value: SSECustomerKey)
    override def sseCustomerKeyMD5Value: Option[SSECustomerKeyMD5] = scala
      .Option(impl.sseCustomerKeyMD5())
      .map(value => value: SSECustomerKeyMD5)
    override def ssekmsKeyIdValue: Option[SSEKMSKeyId] =
      scala.Option(impl.ssekmsKeyId()).map(value => value: SSEKMSKeyId)
    override def ssekmsEncryptionContextValue: Option[SSEKMSEncryptionContext] =
      scala
        .Option(impl.ssekmsEncryptionContext())
        .map(value => value: SSEKMSEncryptionContext)
    override def bucketKeyEnabledValue: Option[BucketKeyEnabled] = scala
      .Option(impl.bucketKeyEnabled())
      .map(value => value: BucketKeyEnabled)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def taggingValue: Option[TaggingHeader] =
      scala.Option(impl.tagging()).map(value => value: TaggingHeader)
    override def objectLockModeValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockMode] = scala
      .Option(impl.objectLockMode())
      .map(value => io.github.vigoo.zioaws.s3.model.ObjectLockMode.wrap(value))
    override def objectLockRetainUntilDateValue
        : Option[ObjectLockRetainUntilDate] = scala
      .Option(impl.objectLockRetainUntilDate())
      .map(value => value: ObjectLockRetainUntilDate)
    override def objectLockLegalHoldStatusValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus] =
      scala
        .Option(impl.objectLockLegalHoldStatus())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockLegalHoldStatus.wrap(value)
        )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRequest
  ): io.github.vigoo.zioaws.s3.model.PutObjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
