package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentMD5,
  BypassGovernanceRetention,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectRetentionRequest(
    bucket: BucketName,
    key: ObjectKey,
    retention: Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention] =
      None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None,
    versionId: Option[ObjectVersionId] = None,
    bypassGovernanceRetention: Option[BypassGovernanceRetention] = None,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    expectedBucketOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest = {
    import PutObjectRetentionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(retention.map(value => value.buildAwsValue()))(
        _.retention
      )
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(
        bypassGovernanceRetention.map(value => value: java.lang.Boolean)
      )(_.bypassGovernanceRetention)
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest
      .wrap(buildAwsValue())
}
object PutObjectRetentionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest =
      io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest(
        bucketValue,
        keyValue,
        retentionValue.map(value => value.editable),
        requestPayerValue.map(value => value),
        versionIdValue.map(value => value),
        bypassGovernanceRetentionValue.map(value => value),
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        expectedBucketOwnerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def retentionValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def versionIdValue: Option[ObjectVersionId]
    def bypassGovernanceRetentionValue: Option[BypassGovernanceRetention]
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def expectedBucketOwnerValue: Option[AccountId]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def retention: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly
    ] = AwsError.unwrapOptionField("retention", retentionValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def bypassGovernanceRetention
        : ZIO[Any, AwsError, BypassGovernanceRetention] =
      AwsError.unwrapOptionField(
        "bypassGovernanceRetention",
        bypassGovernanceRetentionValue
      )
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def retentionValue
        : Option[io.github.vigoo.zioaws.s3.model.ObjectLockRetention.ReadOnly] =
      scala
        .Option(impl.retention())
        .map(value =>
          io.github.vigoo.zioaws.s3.model.ObjectLockRetention.wrap(value)
        )
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def bypassGovernanceRetentionValue
        : Option[BypassGovernanceRetention] = scala
      .Option(impl.bypassGovernanceRetention())
      .map(value => value: BypassGovernanceRetention)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectRetentionRequest
  ): io.github.vigoo.zioaws.s3.model.PutObjectRetentionRequest.ReadOnly =
    new Wrapper(impl)
}
