package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ContentMD5,
  AccountId,
  ObjectKey,
  BucketName,
  ObjectVersionId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectTaggingRequest(
    bucket: BucketName,
    key: ObjectKey,
    versionId: Option[ObjectVersionId] = None,
    contentMD5: Option[ContentMD5] = None,
    checksumAlgorithm: Option[
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = None,
    tagging: io.github.vigoo.zioaws.s3.model.Tagging,
    expectedBucketOwner: Option[AccountId] = None,
    requestPayer: Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest = {
    import PutObjectTaggingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
      .builder()
      .bucket(bucket: java.lang.String)
      .key(key: java.lang.String)
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .optionallyWith(contentMD5.map(value => value: java.lang.String))(
        _.contentMD5
      )
      .optionallyWith(checksumAlgorithm.map(value => value.unwrap))(
        _.checksumAlgorithm
      )
      .tagging(tagging.buildAwsValue())
      .optionallyWith(
        expectedBucketOwner.map(value => value: java.lang.String)
      )(_.expectedBucketOwner)
      .optionallyWith(requestPayer.map(value => value.unwrap))(_.requestPayer)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest
      .wrap(buildAwsValue())
}
object PutObjectTaggingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest =
      io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest(
        bucketValue,
        keyValue,
        versionIdValue.map(value => value),
        contentMD5Value.map(value => value),
        checksumAlgorithmValue.map(value => value),
        taggingValue.editable,
        expectedBucketOwnerValue.map(value => value),
        requestPayerValue.map(value => value)
      )
    def bucketValue: BucketName
    def keyValue: ObjectKey
    def versionIdValue: Option[ObjectVersionId]
    def contentMD5Value: Option[ContentMD5]
    def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm]
    def taggingValue: io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly
    def expectedBucketOwnerValue: Option[AccountId]
    def requestPayerValue: Option[io.github.vigoo.zioaws.s3.model.RequestPayer]
    def bucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketValue)
    def key: ZIO[Any, Nothing, ObjectKey] = ZIO.succeed(keyValue)
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
    def contentMD5: ZIO[Any, AwsError, ContentMD5] =
      AwsError.unwrapOptionField("contentMD5", contentMD5Value)
    def checksumAlgorithm: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm
    ] = AwsError.unwrapOptionField("checksumAlgorithm", checksumAlgorithmValue)
    def tagging
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly] =
      ZIO.succeed(taggingValue)
    def expectedBucketOwner: ZIO[Any, AwsError, AccountId] = AwsError
      .unwrapOptionField("expectedBucketOwner", expectedBucketOwnerValue)
    def requestPayer
        : ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.RequestPayer] =
      AwsError.unwrapOptionField("requestPayer", requestPayerValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest.ReadOnly {
    override def bucketValue: BucketName = impl.bucket(): BucketName
    override def keyValue: ObjectKey = impl.key(): ObjectKey
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
    override def contentMD5Value: Option[ContentMD5] =
      scala.Option(impl.contentMD5()).map(value => value: ContentMD5)
    override def checksumAlgorithmValue
        : Option[io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm] = scala
      .Option(impl.checksumAlgorithm())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.ChecksumAlgorithm.wrap(value)
      )
    override def taggingValue
        : io.github.vigoo.zioaws.s3.model.Tagging.ReadOnly =
      io.github.vigoo.zioaws.s3.model.Tagging.wrap(impl.tagging())
    override def expectedBucketOwnerValue: Option[AccountId] =
      scala.Option(impl.expectedBucketOwner()).map(value => value: AccountId)
    override def requestPayerValue
        : Option[io.github.vigoo.zioaws.s3.model.RequestPayer] = scala
      .Option(impl.requestPayer())
      .map(value => io.github.vigoo.zioaws.s3.model.RequestPayer.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingRequest
  ): io.github.vigoo.zioaws.s3.model.PutObjectTaggingRequest.ReadOnly =
    new Wrapper(impl)
}
