package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.ObjectVersionId
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PutObjectTaggingResponse(
    versionId: Option[ObjectVersionId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse = {
    import PutObjectTaggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
      .builder()
      .optionallyWith(versionId.map(value => value: java.lang.String))(
        _.versionId
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly =
    io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse
      .wrap(buildAwsValue())
}
object PutObjectTaggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse =
      io.github.vigoo.zioaws.s3.model
        .PutObjectTaggingResponse(versionIdValue.map(value => value))
    def versionIdValue: Option[ObjectVersionId]
    def versionId: ZIO[Any, AwsError, ObjectVersionId] =
      AwsError.unwrapOptionField("versionId", versionIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ) extends io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly {
    override def versionIdValue: Option[ObjectVersionId] =
      scala.Option(impl.versionId()).map(value => value: ObjectVersionId)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.PutObjectTaggingResponse
  ): io.github.vigoo.zioaws.s3.model.PutObjectTaggingResponse.ReadOnly =
    new Wrapper(impl)
}
