package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{QueueArn, NotificationId}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class QueueConfiguration(
    id: Option[NotificationId] = None,
    queueArn: QueueArn,
    events: Iterable[io.github.vigoo.zioaws.s3.model.Event],
    filter: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.QueueConfiguration = {
    import QueueConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.QueueConfiguration
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .queueArn(queueArn: java.lang.String)
      .eventsWithStrings(events.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly =
    io.github.vigoo.zioaws.s3.model.QueueConfiguration.wrap(buildAwsValue())
}
object QueueConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.QueueConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.QueueConfiguration =
      io.github.vigoo.zioaws.s3.model.QueueConfiguration(
        idValue.map(value => value),
        queueArnValue,
        eventsValue,
        filterValue.map(value => value.editable)
      )
    def idValue: Option[NotificationId]
    def queueArnValue: QueueArn
    def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event]
    def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ]
    def id: ZIO[Any, AwsError, NotificationId] =
      AwsError.unwrapOptionField("id", idValue)
    def queueArn: ZIO[Any, Nothing, QueueArn] = ZIO.succeed(queueArnValue)
    def events: ZIO[Any, Nothing, List[io.github.vigoo.zioaws.s3.model.Event]] =
      ZIO.succeed(eventsValue)
    def filter: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filterValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ) extends io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly {
    override def idValue: Option[NotificationId] =
      scala.Option(impl.id()).map(value => value: NotificationId)
    override def queueArnValue: QueueArn = impl.queueArn(): QueueArn
    override def eventsValue: List[io.github.vigoo.zioaws.s3.model.Event] = impl
      .events()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.s3.model.Event.wrap(item)
      }
      .toList
    override def filterValue: Option[
      io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter.ReadOnly
    ] = scala
      .Option(impl.filter())
      .map(value =>
        io.github.vigoo.zioaws.s3.model.NotificationConfigurationFilter
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.QueueConfiguration
  ): io.github.vigoo.zioaws.s3.model.QueueConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
