package io.github.vigoo.zioaws.s3.model
import scala.jdk.CollectionConverters._
sealed trait QuoteFields {
  def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields
}
object QuoteFields {
  def wrap(
      value: software.amazon.awssdk.services.s3.model.QuoteFields
  ): io.github.vigoo.zioaws.s3.model.QuoteFields = value match {
    case software.amazon.awssdk.services.s3.model.QuoteFields.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.s3.model.QuoteFields.ALWAYS =>
      val r = ALWAYS
      r
    case software.amazon.awssdk.services.s3.model.QuoteFields.ASNEEDED =>
      val r = ASNEEDED
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.UNKNOWN_TO_SDK_VERSION
  }
  case object ALWAYS extends io.github.vigoo.zioaws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.ALWAYS
  }
  case object ASNEEDED extends io.github.vigoo.zioaws.s3.model.QuoteFields {
    override def unwrap: software.amazon.awssdk.services.s3.model.QuoteFields =
      software.amazon.awssdk.services.s3.model.QuoteFields.ASNEEDED
  }
}
