package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.Body
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RecordsEvent(payload: Option[Body] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.RecordsEvent = {
    import RecordsEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RecordsEvent
      .builder()
      .optionallyWith(
        payload.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.payload)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RecordsEvent.wrap(buildAwsValue())
}
object RecordsEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.RecordsEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RecordsEvent =
      io.github.vigoo.zioaws.s3.model
        .RecordsEvent(payloadValue.map(value => value))
    def payloadValue: Option[Body]
    def payload: ZIO[Any, AwsError, Body] =
      AwsError.unwrapOptionField("payload", payloadValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RecordsEvent
  ) extends io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly {
    override def payloadValue: Option[Body] = scala
      .Option(impl.payload())
      .map(value => zio.Chunk.fromArray(value.asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RecordsEvent
  ): io.github.vigoo.zioaws.s3.model.RecordsEvent.ReadOnly = new Wrapper(impl)
}
