package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.{
  ReplaceKeyWith,
  ReplaceKeyPrefixWith,
  HttpRedirectCode,
  HostName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Redirect(
    hostName: Option[HostName] = None,
    httpRedirectCode: Option[HttpRedirectCode] = None,
    protocol: Option[io.github.vigoo.zioaws.s3.model.Protocol] = None,
    replaceKeyPrefixWith: Option[ReplaceKeyPrefixWith] = None,
    replaceKeyWith: Option[ReplaceKeyWith] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.s3.model.Redirect = {
    import Redirect.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.Redirect
      .builder()
      .optionallyWith(hostName.map(value => value: java.lang.String))(
        _.hostName
      )
      .optionallyWith(httpRedirectCode.map(value => value: java.lang.String))(
        _.httpRedirectCode
      )
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .optionallyWith(
        replaceKeyPrefixWith.map(value => value: java.lang.String)
      )(_.replaceKeyPrefixWith)
      .optionallyWith(replaceKeyWith.map(value => value: java.lang.String))(
        _.replaceKeyWith
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly =
    io.github.vigoo.zioaws.s3.model.Redirect.wrap(buildAwsValue())
}
object Redirect {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.s3.model.Redirect] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.Redirect =
      io.github.vigoo.zioaws.s3.model.Redirect(
        hostNameValue.map(value => value),
        httpRedirectCodeValue.map(value => value),
        protocolValue.map(value => value),
        replaceKeyPrefixWithValue.map(value => value),
        replaceKeyWithValue.map(value => value)
      )
    def hostNameValue: Option[HostName]
    def httpRedirectCodeValue: Option[HttpRedirectCode]
    def protocolValue: Option[io.github.vigoo.zioaws.s3.model.Protocol]
    def replaceKeyPrefixWithValue: Option[ReplaceKeyPrefixWith]
    def replaceKeyWithValue: Option[ReplaceKeyWith]
    def hostName: ZIO[Any, AwsError, HostName] =
      AwsError.unwrapOptionField("hostName", hostNameValue)
    def httpRedirectCode: ZIO[Any, AwsError, HttpRedirectCode] =
      AwsError.unwrapOptionField("httpRedirectCode", httpRedirectCodeValue)
    def protocol: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocolValue)
    def replaceKeyPrefixWith: ZIO[Any, AwsError, ReplaceKeyPrefixWith] =
      AwsError.unwrapOptionField(
        "replaceKeyPrefixWith",
        replaceKeyPrefixWithValue
      )
    def replaceKeyWith: ZIO[Any, AwsError, ReplaceKeyWith] =
      AwsError.unwrapOptionField("replaceKeyWith", replaceKeyWithValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.s3.model.Redirect)
      extends io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly {
    override def hostNameValue: Option[HostName] =
      scala.Option(impl.hostName()).map(value => value: HostName)
    override def httpRedirectCodeValue: Option[HttpRedirectCode] = scala
      .Option(impl.httpRedirectCode())
      .map(value => value: HttpRedirectCode)
    override def protocolValue
        : Option[io.github.vigoo.zioaws.s3.model.Protocol] = scala
      .Option(impl.protocol())
      .map(value => io.github.vigoo.zioaws.s3.model.Protocol.wrap(value))
    override def replaceKeyPrefixWithValue: Option[ReplaceKeyPrefixWith] = scala
      .Option(impl.replaceKeyPrefixWith())
      .map(value => value: ReplaceKeyPrefixWith)
    override def replaceKeyWithValue: Option[ReplaceKeyWith] =
      scala.Option(impl.replaceKeyWith()).map(value => value: ReplaceKeyWith)
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.Redirect
  ): io.github.vigoo.zioaws.s3.model.Redirect.ReadOnly = new Wrapper(impl)
}
