package io.github.vigoo.zioaws.s3.model
import io.github.vigoo.zioaws.s3.model.primitives.HostName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RedirectAllRequestsTo(
    hostName: HostName,
    protocol: Option[io.github.vigoo.zioaws.s3.model.Protocol] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo = {
    import RedirectAllRequestsTo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
      .builder()
      .hostName(hostName: java.lang.String)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly =
    io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.wrap(buildAwsValue())
}
object RedirectAllRequestsTo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo =
      io.github.vigoo.zioaws.s3.model
        .RedirectAllRequestsTo(hostNameValue, protocolValue.map(value => value))
    def hostNameValue: HostName
    def protocolValue: Option[io.github.vigoo.zioaws.s3.model.Protocol]
    def hostName: ZIO[Any, Nothing, HostName] = ZIO.succeed(hostNameValue)
    def protocol: ZIO[Any, AwsError, io.github.vigoo.zioaws.s3.model.Protocol] =
      AwsError.unwrapOptionField("protocol", protocolValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ) extends io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly {
    override def hostNameValue: HostName = impl.hostName(): HostName
    override def protocolValue
        : Option[io.github.vigoo.zioaws.s3.model.Protocol] = scala
      .Option(impl.protocol())
      .map(value => io.github.vigoo.zioaws.s3.model.Protocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.RedirectAllRequestsTo
  ): io.github.vigoo.zioaws.s3.model.RedirectAllRequestsTo.ReadOnly =
    new Wrapper(impl)
}
