package io.github.vigoo.zioaws.s3.model
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ReplicaModifications(
    status: io.github.vigoo.zioaws.s3.model.ReplicaModificationsStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.s3.model.ReplicaModifications = {
    import ReplicaModifications.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.s3.model.ReplicaModifications
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly =
    io.github.vigoo.zioaws.s3.model.ReplicaModifications.wrap(buildAwsValue())
}
object ReplicaModifications {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.s3.model.ReplicaModifications
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.s3.model.ReplicaModifications =
      io.github.vigoo.zioaws.s3.model.ReplicaModifications(statusValue)
    def statusValue: io.github.vigoo.zioaws.s3.model.ReplicaModificationsStatus
    def status: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.s3.model.ReplicaModificationsStatus
    ] = ZIO.succeed(statusValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.s3.model.ReplicaModifications
  ) extends io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly {
    override def statusValue
        : io.github.vigoo.zioaws.s3.model.ReplicaModificationsStatus =
      io.github.vigoo.zioaws.s3.model.ReplicaModificationsStatus
        .wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.s3.model.ReplicaModifications
  ): io.github.vigoo.zioaws.s3.model.ReplicaModifications.ReadOnly =
    new Wrapper(impl)
}
